

path = "C:/Users/ab998/OneDrive - University of Exeter/TDP43 project JG/manuscript/elife/VOR final files/scripts"


########################################################################################
###########################################################


low_ratio = 40


tmpdf = read.table(paste(path.vor, "/E8_caspase.txt", sep=""), sep="\t", header=T)


tmpdf$class = "UNK"
tmpdf$class[which(tmpdf$condition == "Control")] = "bin0"
tmpdf$class[intersect(which(tmpdf$condition == "NES"), which(tmpdf$cyto_nuc > low_ratio ))] = "bin1"
tmpdf$class[intersect(which(tmpdf$condition == "NES"), which(tmpdf$cyto_nuc <= low_ratio))] = "bin2"

table(tmpdf$class)

for(rep in c("R1", "R2", "R3")){
  
  tmpdf$somaexp_meancorrcy5[which(tmpdf$replicate == rep)] = tmpdf$somaexp_meancorrcy5[which(tmpdf$replicate == rep)] / 
                                                             median(tmpdf$somaexp_meancorrcy5[which(tmpdf$replicate == rep & tmpdf$class == "bin0")])  
  
}


plotdf = data.frame(
  condition = tmpdf$class,
  replicate = tmpdf$replicate,
  sample = tmpdf$condition,
  value = tmpdf$somaexp_meancorrcy5,
  NC = tmpdf$cyto_nuc
)

plotdf = plotdf[which(plotdf$condition == "bin0" | plotdf$condition == "bin1" | plotdf$condition == "bin2"), ]
plotdf$condition = factor(plotdf$condition, levels = c("bin0", "bin1", "bin2"))

#### colors

colors <- c("deepskyblue4", "green4", "red3") # Colors for the replicates
colors.class <- c("coral1", "dodgerblue", "deepskyblue") # Colors for the replicates
col.bin = "grey80"
img.w = 6
img.h = 6
img.u = "in"
marvec = c(4,7,2,2)
boxwex = 0.5
x.cex = 3
cexval = 0.8
lwd=4
lwd.tick=4

#########################################################################################
## plot NC values per replicate for nes0 and nesm

filename = paste(path, "/figures/E8-casp-boxplot-display-nes0-nesm-NC.tiff", sep="")
tiff(filename, width=img.w, height=img.h, units=img.u, res=300, compression = "jpeg")

par(mar = c(4, 6, 2, 2) + 0.1)
posvec = c(1,2,3,4)

boxplot(plotdf$NC[which(plotdf$sample == "Control")], plotdf$NC[which(plotdf$sample == "NES")], 0,0,
        outline=F, las=2, ylim=c(0,100),
        lwd=2, boxwex=boxwex, frame=F, col=colors.class,
        at=posvec, axes=FALSE
)
axis(2, cex.axis=x.cex, las=2, lwd=lwd, lwd.ticks=lwd.tick)

dev.off()

###

filename = paste(path, "/figures/E8-casp-boxplot-display-nes0-nesm-NC-with-datapoints.tiff", sep="")
tiff(filename, width=img.w, height=img.h, units=img.u, res=300, compression = "jpeg")

par(mar = c(4, 6, 2, 2) + 0.1)
posvec = c(1,2,3,4)

boxplot(plotdf$NC[which(plotdf$sample == "Control")], plotdf$NC[which(plotdf$sample == "NES")],0,0,
        outline=F, las=2, ylim=c(0,100),
        lwd=2, boxwex=boxwex, frame=F, col=rep(col.bin, 2),
        at=posvec, axes=FALSE
)
axis(2, cex.axis=x.cex, las=2, lwd=lwd, lwd.ticks=lwd.tick)

samplevec = c("Control", "NES")
repvec = c("R1", "R2", "R3")
rep.posvec = c(-0.25, 0, 0.25)

numdp.df = data.frame(matrix(0, nrow=length(samplevec), ncol=length(repvec)))
rownames(numdp.df) = samplevec
colnames(numdp.df) = repvec

for (i in 1:length(samplevec)) {
  subset_data <- plotdf[which(plotdf$sample == samplevec[i]), c("replicate", "NC")]
  for (j in 1:length(repvec)) {
    repdata = subset_data$NC[which(subset_data$replicate == repvec[j])]
    print(length(repdata))
    numdp.df[i,j] = length(repdata)
    points(jitter(rep(posvec[i] + rep.posvec[j], length(repdata)), amount=0.1), repdata, col = colors[as.numeric(j)], pch = 20, cex=cexval)
  }
}

dev.off()

numdp.df$sample = rownames(numdp.df)
write.table(numdp.df, file = paste(path, "/figures/E8-casp-boxplot-display-nes0-nesm-NC_numbers.txt", sep=""), 
            col.names = T, row.names = F, quote = F)

#########################################################################################

filename = paste(path, "/figures/E8-casp-boxplot.tiff", sep="")
tiff(filename, width=img.w, height=img.h, units=img.u, res=300, compression = "jpeg")

par(mar = marvec + 0.1)
posvec = c(1,2,3)

boxplot(plotdf$value[which(plotdf$condition == "bin0")], 
        plotdf$value[which(plotdf$condition == "bin1")],
        plotdf$value[which(plotdf$condition == "bin2")],
        
        outline=F, las=2, ylim=c(0,3.5),
        lwd=lwd, boxwex=boxwex, frame=F, col=colors.class,
        at=posvec, axes=FALSE
)
axis(2, cex.axis=x.cex, las=2, lwd=lwd, lwd.ticks=lwd.tick)

dev.off()



filename = paste(path, "/figures/E8-casp-boxplot-with-datapoints.tiff", sep="")
tiff(filename, width=img.w, height=img.h, units=img.u, res=300, compression = "jpeg")

par(mar = c(4, 6, 2, 2) + 0.1)
posvec = c(1,2.5,4)

boxplot(plotdf$value[which(plotdf$condition == "bin0")], 
        plotdf$value[which(plotdf$condition == "bin1")],
        plotdf$value[which(plotdf$condition == "bin2")],
        
        outline=F, las=2, ylim=c(0,8),
        lwd=lwd, boxwex=boxwex, frame=F, col=rep(col.bin, 3),
        at=posvec, axes=FALSE
)
axis(2, cex.axis=x.cex, las=2, lwd=lwd, lwd.ticks=lwd.tick)


# Step 3: Overlay individual points, colored by replicate

condvec = c("bin0", "bin1", "bin2")
repvec = c("R1", "R2", "R3")
rep.posvec = c(-0.25, 0, 0.25)

numdp.df = data.frame(matrix(0, nrow=length(condvec), ncol=length(repvec)))
rownames(numdp.df) = condvec
colnames(numdp.df) = repvec

for (i in 1:length(condvec)) {
  subset_data <- plotdf[which(plotdf$condition == condvec[i]), c("replicate", "value")]
  for (j in 1:length(repvec)) {
    repdata = subset_data$value[which(subset_data$replicate == repvec[j])]
    
    print(c(condvec[i], repvec[j], length(repdata)))
    numdp.df[i, j] = length(repdata)
    points(jitter(rep(posvec[i] + rep.posvec[j], length(repdata)), amount=0.1), repdata, col = colors[as.numeric(j)], pch = 20, cex=cexval)
  }
}

dev.off()

numdp.df$condition = rownames(numdp.df)
write.table(numdp.df, file = paste(path, "/figures/E8-casp-boxplot-with-datapoints_numbers.txt", sep=""), sep="\t", 
            col.names = T, row.names = F, quote = F)



#################################################################################
#################################################################################
## plot the NC values per bin

filename = paste(path, "/figures/E8-casp-boxplot-low-med-high-display-NC-with-datapoints.tiff", sep="")
tiff(filename, width=5, height=5, units="in", res=300, compression = "jpeg")

par(mar = c(4, 6, 2, 2) + 0.1)
posvec = c(1,2,3)

boxplot(plotdf$NC[which(plotdf$condition == "bin0")], 
        plotdf$NC[which(plotdf$condition == "bin1")],
        plotdf$NC[which(plotdf$condition == "bin2")],
        
        outline=F, las=2, ylim=c(0,100),
        lwd=lwd, boxwex=boxwex, frame=F, col=rep(col.bin, 3),
        at=posvec, axes=FALSE
)
axis(2, cex.axis=4.0, las=2, lwd=lwd, lwd.ticks=lwd.tick)


# Step 3: Overlay individual points, colored by replicate

condvec = c("bin0", "bin1", "bin2")
repvec = c("R1", "R2", "R3")
rep.posvec = c(-0.25, 0, 0.25)

for (i in 1:length(condvec)) {
  subset_data <- plotdf[which(plotdf$condition == condvec[i]), c("replicate", "NC")]
  for (j in 1:length(repvec)) {
    repdata = subset_data$NC[which(subset_data$replicate == repvec[j])]
    points(jitter(rep(posvec[i] + rep.posvec[j], length(repdata)), amount=0.1), repdata, col = colors[as.numeric(j)], pch = 20, cex=cexval)
  }
}

dev.off()


#################################################################################

bin01 = wilcox.test(plotdf$value[which(plotdf$condition == "bin0")], plotdf$value[which(plotdf$condition == "bin1")])
bin02 = wilcox.test(plotdf$value[which(plotdf$condition == "bin0")], plotdf$value[which(plotdf$condition == "bin2")])
bin12 = wilcox.test(plotdf$value[which(plotdf$condition == "bin1")], plotdf$value[which(plotdf$condition == "bin2")])

pvaldf = data.frame(matrix(nrow=9, ncol=2))

pvaldf[1, ] = c("quantile", 0)
pvaldf[2, ] = c("bin01.p", bin01$p.value)
pvaldf[3, ] = c("bin02.p", bin02$p.value)
pvaldf[4, ] = c("bin12.p", bin12$p.value)
pvaldf[5, ] = c("high.cytonuc", high_ratio)
pvaldf[6, ] = c("low.cytonuc", low_ratio)
pvaldf[7, ] = c("num_bin0", length(plotdf$value[which(plotdf$condition == "bin0")]))
pvaldf[8, ] = c("num_bin1", length(plotdf$value[which(plotdf$condition == "bin1")]))
pvaldf[9, ] = c("num_bin2", length(plotdf$value[which(plotdf$condition == "bin2")]))

write.table(pvaldf, paste(path, "/figures/E8-casp-boxplot-quantile-pvals.txt", sep=""), sep="\t", row.names = F, col.names = F, quote = F)

#################################################################################
#################################################################################


